<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name', 'slug', 'image', 'parent_id');

    public function parent()
    {
        return $this->belongsTo('App\Models\Category', 'parent_id');
    }

    public function posts()
    {
        return $this->hasMany('App\Models\Post');
    }

}